/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class PhasingPower
extends Power {
    private final Predicate<CachedBlockInfo> blocks;
    private final boolean isBlacklist;
    private final Predicate<PlayerEntity> phaseDownCondition;
    private final RenderType renderType;
    private final float viewDistance;

    public PhasingPower(PowerType<?> type, PlayerEntity player, Predicate<CachedBlockInfo> blocks, boolean isBlacklist, RenderType renderType, float viewDistance, Predicate<PlayerEntity> phaseDownCondition) {
        super(type, player);
        this.blocks = blocks;
        this.isBlacklist = isBlacklist;
        this.renderType = renderType;
        this.viewDistance = viewDistance;
        this.phaseDownCondition = phaseDownCondition;
    }

    public boolean doesApply(BlockPos pos) {
        return this.isBlacklist != this.blocks.test(new CachedBlockInfo((IWorldReader)this.player.field_70170_p, pos, true));
    }

    public boolean shouldPhaseDown(PlayerEntity playerEntity) {
        return this.phaseDownCondition == null ? playerEntity.func_225608_bj_() : this.phaseDownCondition.test(playerEntity);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public float getViewDistance() {
        return this.viewDistance;
    }

    public static enum RenderType {
        BLINDNESS,
        REMOVE_BLOCKS;

    }
}

